/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.StyleValue;

class FontVariantShorthandSetter
extends ShorthandSetter {
    FontVariantShorthandSetter(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        super(baseCSSStyleDeclaration, "font-variant");
    }

    @Override
    public boolean assignSubproperties() {
        if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
            String string = this.currentValue.getStringValue();
            boolean bl = false;
            if (string.equalsIgnoreCase("normal") || (bl = string.equalsIgnoreCase("none"))) {
                if (this.currentValue.getNextLexicalUnit() == null) {
                    IdentifierValue identifierValue = new IdentifierValue("normal");
                    identifierValue.setSubproperty(true);
                    String[] stringArray = this.getShorthandSubproperties();
                    for (String string2 : stringArray) {
                        this.styleDeclaration.setProperty(string2, identifierValue, this.isPriorityImportant());
                    }
                    if (bl) {
                        IdentifierValue identifierValue2 = new IdentifierValue("none");
                        identifierValue2.setSubproperty(true);
                        this.styleDeclaration.setProperty("font-variant-ligatures", identifierValue2, this.isPriorityImportant());
                    }
                    this.initValueString();
                    this.appendValueItemString(string);
                    return true;
                }
                StyleDeclarationErrorHandler styleDeclarationErrorHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
                if (styleDeclarationErrorHandler != null) {
                    styleDeclarationErrorHandler.shorthandError(this.getShorthandName(), "Found '" + string + "' keyword mixed with other values");
                }
                return false;
            }
        }
        return super.assignSubproperties();
    }

    @Override
    protected boolean assignSubproperty(String string) {
        switch (this.currentValue.getLexicalUnitType()) {
            case IDENT: {
                if (string.equals("font-variant-alternates") && this.testFontVariantAlternates()) {
                    return true;
                }
                boolean bl = false;
                while (this.currentValue != null) {
                    if (this.testIdentifiers(string)) {
                        StyleValue styleValue = this.createCSSValue(string, this.currentValue);
                        this.addSubpropertyValue(string, styleValue, false);
                        bl = true;
                        this.nextCurrentValue();
                        if (this.currentValue != null && this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) continue;
                        break;
                    }
                    return bl;
                }
                return bl;
            }
            case FUNCTION: {
                if (!string.equals("font-variant-alternates") || !this.testFontVariantAlternates()) break;
                return true;
            }
        }
        return false;
    }

    private boolean testFontVariantAlternates() {
        boolean bl = false;
        while (this.currentValue != null) {
            switch (this.currentValue.getLexicalUnitType()) {
                case IDENT: {
                    StyleValue styleValue;
                    if (this.testIdentifiers("font-variant-alternates")) {
                        styleValue = this.createCSSValue("font-variant-alternates", this.currentValue);
                        this.addSubpropertyValue("font-variant-alternates", styleValue, false);
                        this.nextCurrentValue();
                        bl = true;
                        break;
                    }
                    return bl;
                }
                case FUNCTION: {
                    StyleValue styleValue = this.createCSSValue("font-variant-alternates", this.currentValue);
                    this.addSubpropertyValue("font-variant-alternates", styleValue, false);
                    this.nextCurrentValue();
                    bl = true;
                }
            }
        }
        return bl;
    }
}

